/*
 * Decompiled with CFR 0.152.
 */
package dan200.computercraft.api.client.turtle;

import dan200.computercraft.api.client.ModelLocation;
import dan200.computercraft.api.client.TransformedModel;
import dan200.computercraft.api.client.turtle.TurtleUpgradeModellers;
import dan200.computercraft.api.turtle.ITurtleAccess;
import dan200.computercraft.api.turtle.ITurtleUpgrade;
import dan200.computercraft.api.turtle.TurtleSide;
import java.util.stream.Stream;
import net.minecraft.core.component.DataComponentPatch;
import net.minecraft.resources.ResourceLocation;
import org.jspecify.annotations.Nullable;

public interface TurtleUpgradeModeller<T extends ITurtleUpgrade> {
    public TransformedModel getModel(T var1, @Nullable ITurtleAccess var2, TurtleSide var3, DataComponentPatch var4);

    default public Stream<ResourceLocation> getDependencies() {
        return Stream.of(new ResourceLocation[0]);
    }

    public static <T extends ITurtleUpgrade> TurtleUpgradeModeller<T> flatItem() {
        return TurtleUpgradeModellers.UPGRADE_ITEM;
    }

    public static <T extends ITurtleUpgrade> TurtleUpgradeModeller<T> sided(ResourceLocation left, ResourceLocation right) {
        return TurtleUpgradeModeller.sided(ModelLocation.ofResource(left), ModelLocation.ofResource(right));
    }

    public static <T extends ITurtleUpgrade> TurtleUpgradeModeller<T> sided(final ModelLocation left, final ModelLocation right) {
        return new TurtleUpgradeModeller<T>(){

            @Override
            public TransformedModel getModel(T upgrade, @Nullable ITurtleAccess turtle, TurtleSide side, DataComponentPatch data) {
                return TransformedModel.of(side == TurtleSide.LEFT ? left : right);
            }

            @Override
            public Stream<ResourceLocation> getDependencies() {
                return Stream.of(left, right).flatMap(ModelLocation::getDependencies);
            }
        };
    }
}

